data "aws_iam_policy_document" "ec2_assume" {
  statement {
    actions = [
      "sts:AssumeRole",
    ]

    principals {
      type        = "Service"
      identifiers = ["ec2.amazonaws.com"]
    }
  }

  statement {
    actions = [
      "sts:AssumeRole",
    ]

    principals {
      type        = "AWS"
      identifiers = ["${var.worker_iam_role_arn}"]
    }
  }
}

data "aws_iam_policy_document" "autoscaler" {
  statement {
    actions = [
      "autoscaling:DescribeAutoScalingGroups",
      "autoscaling:DescribeAutoScalingInstances",
      "autoscaling:SetDesiredCapacity",
      "autoscaling:TerminateInstanceInAutoScalingGroup",
      "autoscaling:DescribeTags",
      "autoscaling:DescribeLaunchConfigurations",
      "ec2:DescribeLaunchTemplateVersions", 
    ]

    resources = [
      "*"
    ]
  }
}

resource "aws_iam_policy" "this" {
  policy = "${data.aws_iam_policy_document.autoscaler.json}"
}

resource "aws_iam_role" "this" {
  name               = "eks-cluster-autoscaler"
  assume_role_policy = "${data.aws_iam_policy_document.ec2_assume.json}"
}

resource "aws_iam_role_policy_attachment" "this" {
  role       = "${aws_iam_role.this.name}"
  policy_arn = "${aws_iam_policy.this.arn}"
}
