variable "ami_id" {
  description = "Custom AMI ID for the EKS cluster; defaults to latest Amazon-provided AMI if empty"
  default     = ""
}

variable "cluster_name" {
  description = "Name for the EKS cluster"
}

variable "cluster_version" {
  description = "Kubernetes version to use for the EKS cluster"
  default     = "1.10"
}

variable "vpc_id" {
  description = "VPC ID to use for cluster - ensure VPC is properly enabled for EKS using tf_mod_aws_vpc"
}

variable "private_subnets" {
  description = "Private subnets for the EKS master and workers to be present within - requires the use of NAT gateways!"
  type        = "list"
}

variable "additional_userdata" {
  description = "Additional userdata in bash form to be executed at first boot for EKS workers"
  default     = ""
}

variable "desired_workers" {
  description = "Desired number of EKS worker nodes"
  default     = 3
}

variable "min_workers" {
  description = "Minimum number of EKS worker nodes"
  default     = 1
}

variable "max_workers" {
  description = "Maximum number of EKS worker nodes"
  default     = 3
}

variable "ebs_optimized_workers" {
  description = "Optionally enable EBS optimization for EKS worker nodes"
  default     = true
}

variable "instance_type" {
  description = "Instance type for EKS worker nodes"
  default     = "m4.large"
}

variable "max_pods_per_worker" {
  description = "Maximum number of pods per EKS worker node - see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI"
  default     = "20"
}

variable "kubelet_extra_args" {
  description = "Extra arguments to be passed through to kubelet"
  default     = ""
}

variable "steamhaus_role_arn" {
  description = "Role ARN within the account for Steamhaus federated access"
}
