#!/bin/bash -xe

# Bootstrap and join the cluster
/etc/eks/bootstrap.sh --b64-cluster-ca '${cluster_auth_base64}' --apiserver-endpoint '${endpoint}' --use-max-pods '${max_pod_count}' --kubelet-extra-args '${kubelet_extra_args}' '${cluster_name}'

# Install cron
yum -y install crontabs
chkconfig crond on
service crond start

# Add Steamhaus user
adduser steamhaus
passwd -l steamhaus
mkdir -p /home/steamhaus/bin
mkdir -p /home/steamhaus/.ssh
chmod 700 /home/steamhaus/.ssh

# Ensure Steamhaus user has full passwordless root
echo "steamhaus ALL=(ALL)NOPASSWD:ALL" > /etc/sudoers.d/steamhaus
chmod 440 /etc/sudoers.d/steamhaus

# Create Steamhaus SSH credential update script
wget --no-check-certificate "https://gist.githubusercontent.com/chrisfu/87b642951aadafa62b99/raw/sh_pubkey_update.sh" -O /home/steamhaus/bin/sh_pubkey_update.sh
sed -i s,\`whoami\`,steamhaus,g /home/steamhaus/bin/sh_pubkey_update.sh
chmod 755 /home/steamhaus/bin/sh_pubkey_update.sh

# Perform first-time update of Steamhaus SSH credentials
/home/steamhaus/bin/sh_pubkey_update.sh
echo "0 1 * * * /home/steamhaus/bin/sh_pubkey_update.sh" > /var/spool/cron/steamhaus

# Ensure everything within Steamhaus home directory is owned by Steamhaus
chown -R steamhaus: /home/steamhaus/

# Allow user supplied userdata code
${additional_userdata}
