output "cluster_id" {
  description = "The name/id of the EKS cluster"
  value       = "${aws_eks_cluster.cluster.id}"
}

output "cluster_certificate_authority_data" {
  description = "Nested attribute containing certificate-authority-data for your cluster. This is the base64 encoded certificate data required to communicate with your cluster"
  value       = "${aws_eks_cluster.cluster.certificate_authority.0.data}"
}

output "cluster_endpoint" {
  description = "The endpoint for your EKS Kubernetes API"
  value       = "${aws_eks_cluster.cluster.endpoint}"
}

output "cluster_version" {
  description = "The Kubernetes server version for the EKS cluster"
  value       = "${aws_eks_cluster.cluster.version}"
}

output "masters_sg_id" {
  description = "Security group ID attached to the EKS cluster masters"
  value       = "${aws_security_group.masters.id}"
}

output "workers_sg_id" {
  description = "Security group ID attached to the EKS cluster workers"
  value       = "${aws_security_group.workers.id}"
}

output "worker_iam_role_name" {
  description = "IAM role name attached to EKS cluster workers"
  value       = "${aws_iam_role.workers.name}"
}

output "config_map_aws_auth" {
  description = "A kubernetes configuration to authenticate to this EKS cluster."
  value       = "${data.template_file.config_map_aws_auth.rendered}"
}

output "kubeconfig" {
  description = "kubectl config file contents for this EKS cluster."
  value       = "${data.template_file.kubeconfig.rendered}"
}
