resource "aws_eks_cluster" "cluster" {
  name     = "${var.cluster_name}"
  role_arn = "${aws_iam_role.masters.arn}"

  vpc_config {
    security_group_ids = ["${aws_security_group.masters.id}"]
    subnet_ids         = ["${var.private_subnets}"]
  }

  depends_on = [
    "aws_iam_role_policy_attachment.masters_cluster_policy",
    "aws_iam_role_policy_attachment.masters_service_policy",
  ]
}

resource "aws_security_group" "masters" {
  name        = "${var.cluster_name}-eks-masters"
  description = "Cluster communication with EKS worker nodes"
  vpc_id      = "${var.vpc_id}"

  egress {
    from_port   = 0
    to_port     = 0
    protocol    = "-1"
    cidr_blocks = ["0.0.0.0/0"]
  }

  tags {
    Name = "${var.cluster_name}-eks-masters"
  }
}

resource "aws_security_group_rule" "masters_api_allow_from_workers" {
  description              = "Allow an EKS workers pods to communicate with the EKS cluster API Server"
  from_port                = 443
  protocol                 = "tcp"
  security_group_id        = "${aws_security_group.masters.id}"
  source_security_group_id = "${aws_security_group.workers.id}"
  to_port                  = 443
  type                     = "ingress"
}

resource "aws_iam_role" "masters" {
  name = "${var.cluster_name}-eks-masters"

  assume_role_policy = "${data.aws_iam_policy_document.masters.json}"
}

resource "aws_iam_role_policy_attachment" "masters_cluster_policy" {
  policy_arn = "arn:aws:iam::aws:policy/AmazonEKSClusterPolicy"
  role       = "${aws_iam_role.masters.name}"
}

resource "aws_iam_role_policy_attachment" "masters_service_policy" {
  policy_arn = "arn:aws:iam::aws:policy/AmazonEKSServicePolicy"
  role       = "${aws_iam_role.masters.name}"
}

resource "aws_iam_role" "admin" {
  name                 = "${var.cluster_name}-eks-kubernetes-admin"
  max_session_duration = 43200

  assume_role_policy = "${data.aws_iam_policy_document.admin.json}"
}

resource "aws_iam_group" "admin" {
  name = "${var.cluster_name}-eks-kubernetes-admin"
}

resource "aws_iam_policy" "admin_assumerole" {
  name   = "${var.cluster_name}-eks-kubernetes-admin-assumerole"
  policy = "${data.aws_iam_policy_document.admin_assumerole.json}"
}

resource "aws_iam_group_policy_attachment" "admin_assumerole" {
  group      = "${aws_iam_group.admin.name}"
  policy_arn = "${aws_iam_policy.admin_assumerole.arn}"
}
