variable "name" {
  description = "The name of the AWS resources created by this module"
}

variable "ami_name_pattern" {
  description = "The name pattern of the AMI to launch the backup instance from"
  default     = "amzn-ami-hvm-2017*"
}

variable "ami_owner" {
  description = "The owner of the AMI to launch the backup instance from"
  default     = "amazon"
}

variable "instance_type" {
  description = "The instance type of the backup instance"
  default     = "t2.micro"
}

variable "security_groups" {
  description = "A list of security group IDs for the backup instance to be a member of"
  type        = "list"
}

variable "efs_mount_target" {
  description = "The DNS endpoint of the EFS volume to backup"
}

variable "s3_bucket_path" {
  description = "The S3 bucket (and optionally directory) to backup to"
  default     = ""
}

variable "manage_s3_bucket" {
  description = "Whether to create and manage the backup S3 bucket"
  default     = true
}

variable "backup_retention_period" {
  description = "The number of days to keep backups for, only used when manage_s3_bucket = true"
  default     = 14
}

variable "backup_archive_name" {
  description = "The name of the resulting backup archive, a timestamp will be added to the end"
}

variable "subnet_ids" {
  description = "A list of subnet IDs for the temporary instance to launch into"
  type        = "list"
}

variable "recurrence" {
  description = "The cron schedule to use for the backup"
  default     = "0 1 * * *"
}

variable "root_volume_size" {
  description = "The size of the backup instances root volume, needs to be larger than the EFS to be backed up"
  default     = 10
}

variable "key_name" {
  description = "An optional SSH key pair to launch the backup instance with"
  default     = ""
}
