#!/bin/bash

# mount efs
mkdir /efs
mount -t nfs4 -o nfsvers=4.1,rsize=1048576,wsize=1048576,hard,timeo=600,retrans=2 ${efs_mount_target}:/ /efs

# create archive
cd /
mkdir efs_backup
cd efs_backup
tar -zcvf ${backup_archive_name} /efs

# unmount efs
umount /efs

# copy archive to s3
aws s3 cp --sse AES256 ${backup_archive_name} s3://${s3_bucket_path}/${backup_archive_name}.`date +"%Y%m%d-%H%M"`.tar.gz

# self terminate by changing the desired ASG capacity to zero
aws autoscaling --region ${region} set-desired-capacity --auto-scaling-group-name ${name} --desired-capacity 0 --no-honor-cooldown
