resource "aws_s3_bucket" "efs_backup" {
  count         = "${var.manage_s3_bucket ? 1 : 0}"
  bucket        = "${var.name}"
  acl           = "private"

  lifecycle_rule {
    id      = "efs_backup_cleanup"
    enabled = true

    expiration {
      days = "${var.backup_retention_period}"
    }
  }
}

data "aws_iam_policy_document" "efs_backup_always_enc" {
  count         = "${var.manage_s3_bucket ? 1 : 0}"
  statement {
    sid       = "DenyIncorrectEncryptionHeader"
    effect    = "Deny"
    actions   = ["s3:PutObject"]
    resources = ["${join("", aws_s3_bucket.efs_backup.*.arn)}/*"]

    principals {
      type        = "AWS"
      identifiers = ["*"]
    }

    condition {
      test     = "StringNotEquals"
      variable = "s3:x-amz-server-side-encryption"
      values   = ["AES256"]
    }
  }

  statement {
    sid       = "DenyUnEncryptedObjectUploads"
    effect    = "Deny"
    actions   = ["s3:PutObject"]
    resources = ["${join("", aws_s3_bucket.efs_backup.*.arn)}/*"]

    principals {
      type        = "AWS"
      identifiers = ["*"]
    }

    condition {
      test     = "Null"
      variable = "s3:x-amz-server-side-encryption"
      values   = ["true"]
    }
  }
}

resource "aws_s3_bucket_policy" "efs_backup" {
  count         = "${var.manage_s3_bucket ? 1 : 0}"
  bucket = "${join("", aws_s3_bucket.efs_backup.*.id)}"
  policy = "${data.aws_iam_policy_document.efs_backup_always_enc.json}"
}
