resource "aws_iam_instance_profile" "backup_efs_node" {
  name = "${var.name}"
  role = "${aws_iam_role.backup_efs_node.name}"
}

data "aws_iam_policy_document" "backup_efs_node_policy" {
  statement {
    actions = [
      "s3:ListBucket",
    ]

    resources = [
      "arn:aws:s3:::${var.s3_bucket_path == "" ? join("", aws_s3_bucket.efs_backup.*.id) : var.s3_bucket_path}",
      "arn:aws:s3:::${var.s3_bucket_path == "" ? join("", aws_s3_bucket.efs_backup.*.id) : var.s3_bucket_path}/*",
    ]
  }

  statement {
    actions = [
      "s3:PutObject",
    ]

    resources = [
      "arn:aws:s3:::${var.s3_bucket_path == "" ? join("", aws_s3_bucket.efs_backup.*.id) : var.s3_bucket_path}/*",
    ]
  }

  statement {
    actions = [
      "autoscaling:SetDesiredCapacity",
    ]

    resources = [
      "${aws_autoscaling_group.backup_efs_node.arn}",
    ]
  }
}

data "aws_iam_policy_document" "backup_efs_node_assume" {
  statement {
    actions = [
      "sts:AssumeRole",
    ]

    principals {
      type        = "Service"
      identifiers = ["ec2.amazonaws.com"]
    }
  }
}

resource "aws_iam_role" "backup_efs_node" {
  name               = "${var.name}"
  path               = "/"
  assume_role_policy = "${data.aws_iam_policy_document.backup_efs_node_assume.json}"
}

resource "aws_iam_policy" "backup_efs_node" {
  name   = "${var.name}"
  policy = "${data.aws_iam_policy_document.backup_efs_node_policy.json}"
}

resource "aws_iam_policy_attachment" "backup_efs_node" {
  name       = "${var.name}"
  roles      = ["${aws_iam_role.backup_efs_node.name}"]
  policy_arn = "${aws_iam_policy.backup_efs_node.arn}"
}
