tf_mod_aws_efs_backup
=====================

A terraform module to backup a desired EFS mount to a desired S3 bucket.

What this module does
---------------------

- Creates an autoscaling group to launch a short lived backup instance on a
schedule
- Creates the schedule to scale up at the desired time
- Creates a launch configuration with a shell script passed as userdata to
trigger the backup
- Optionally creates an S3 bucket to backup to with a lifecycle rule to delete
backups after a desired number of days
- Creates an IAM instance profile to grant the backup instance `s3:PutObject`
rights to the desired S3 bucket and `autoscaling:SetDesiredCapacity` rights to
set the autoscaling group's desired capacity back to zero after the instance has
finished the backup

What this module doesn't do
---------------------------

- Create the security group for the backup instance to access the EFS mount
- Monitor the successful running of the backup, suggest setting a Cloudwatch
alarm on the number of puts to the desired backup S3 bucket over a period of
time
